/*
 * Decompiled with CFR 0.152.
 */
package dev.jaxui.verseInstaller;

import com.formdev.flatlaf.FlatDarkLaf;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class VerseInstallerApp
extends JFrame {
    private static final String SERVER_HTTP = "http://206.45.90.56:5544";
    private final CardLayout cards = new CardLayout();
    private final JPanel root = new JPanel(this.cards);
    private final JTextField loginUser = new JTextField(18);
    private final JPasswordField loginPass = new JPasswordField(18);
    private final JButton btnLogin = new JButton("Log In");
    private final JButton btnGoSignup = new JButton("Register Here");
    private final JLabel loginStatus = new JLabel(" ");
    private final JTextField suUser = new JTextField(18);
    private final JPasswordField suPass = new JPasswordField(18);
    private final JTextField suRegKey = new JTextField(18);
    private final JButton btnSignup = new JButton("Create Account");
    private final JButton btnGoLogin = new JButton("Back to Login");
    private final JLabel signupStatus = new JLabel(" ");
    private final JLabel helloUser = new JLabel("Hello, ?");
    private final JTextField pathField = new JTextField(System.getProperty("user.home") + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "mods");
    private final JButton browseButton = new JButton("Browse\u2026");
    private final JButton installBtn = new JButton("Install Loader");
    private final JLabel installStatus = new JLabel(" ");
    private String currentUser = null;
    private String token = null;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new FlatDarkLaf());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> new VerseInstallerApp().setVisible(true));
    }

    public VerseInstallerApp() {
        this.setTitle("Verse Installer");
        this.setDefaultCloseOperation(3);
        this.setSize(600, 300);
        this.setLocationRelativeTo(null);
        this.root.add((Component)this.buildLoginCard(), "login");
        this.root.add((Component)this.buildSignupCard(), "signup");
        this.root.add((Component)this.buildInstallCard(), "install");
        this.setContentPane(this.root);
        this.cards.show(this.root, "login");
    }

    private JPanel buildLoginCard() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = this.gbc();
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel("Username:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        p.add((Component)this.loginUser, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Password:"), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        p.add((Component)this.loginPass, c);
        JPanel buttons = new JPanel(new FlowLayout(0, 8, 0));
        buttons.add(this.btnLogin);
        buttons.add(this.btnGoSignup);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        p.add((Component)buttons, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        this.loginStatus.setForeground(new Color(200, 200, 200));
        p.add((Component)this.loginStatus, c);
        this.btnLogin.addActionListener(e -> this.doLogin());
        this.btnGoSignup.addActionListener(e -> this.cards.show(this.root, "signup"));
        return p;
    }

    private JPanel buildSignupCard() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = this.gbc();
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel("Username:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        p.add((Component)this.suUser, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Password:"), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        p.add((Component)this.suPass, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Registration Key:"), c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        p.add((Component)this.suRegKey, c);
        JPanel buttons = new JPanel(new FlowLayout(0, 8, 0));
        buttons.add(this.btnSignup);
        buttons.add(this.btnGoLogin);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        p.add((Component)buttons, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        this.signupStatus.setForeground(new Color(200, 200, 200));
        p.add((Component)this.signupStatus, c);
        this.btnSignup.addActionListener(e -> this.doSignup());
        this.btnGoLogin.addActionListener(e -> this.cards.show(this.root, "login"));
        return p;
    }

    private JPanel buildInstallCard() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = this.gbc();
        this.helloUser.setFont(this.helloUser.getFont().deriveFont(1, 16.0f));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        p.add((Component)this.helloUser, c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)new JLabel("Install Path:"), c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        p.add((Component)this.pathField, c);
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 0.0;
        p.add((Component)this.browseButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        p.add((Component)this.installBtn, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        this.installStatus.setForeground(new Color(200, 200, 200));
        p.add((Component)this.installStatus, c);
        this.browseButton.addActionListener(e -> this.choosePath());
        this.installBtn.addActionListener(e -> this.doInstall());
        return p;
    }

    private GridBagConstraints gbc() {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(8, 8, 8, 8);
        c.fill = 2;
        return c;
    }

    private void doLogin() {
        this.setLoginStatus("Logging in\u2026");
        this.btnLogin.setEnabled(false);
        new Thread(() -> {
            try {
                String user = this.loginUser.getText().trim();
                String pass = new String(this.loginPass.getPassword());
                if (user.isEmpty() || pass.isEmpty()) {
                    this.setLoginStatus("Enter username and password.");
                    this.btnLogin.setEnabled(true);
                    return;
                }
                HttpClient client = HttpClient.newHttpClient();
                String payload = "{\"user\":\"" + VerseInstallerApp.json(user) + "\",\"pass\":\"" + VerseInstallerApp.json(pass) + "\"}";
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create("http://206.45.90.56:5544/v1/login")).header("Content-Type", "application/json; charset=UTF-8").POST(HttpRequest.BodyPublishers.ofString(payload, StandardCharsets.UTF_8)).build();
                HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
                if (resp.statusCode() != 200) {
                    this.setLoginStatus("Server error: " + String.valueOf(resp.statusCode() == 401 ? "Invalid login or registration key!" : Integer.valueOf(resp.statusCode())));
                    this.btnLogin.setEnabled(true);
                    return;
                }
                if (!resp.body().contains("\"ok\":true")) {
                    this.setLoginStatus("Invalid credentials.");
                    this.btnLogin.setEnabled(true);
                    return;
                }
                String t = VerseInstallerApp.extractJsonString(resp.body(), "token");
                if (t == null || t.length() != 16) {
                    this.setLoginStatus("Bad token from server.");
                    this.btnLogin.setEnabled(true);
                    return;
                }
                if (!this.writeTokenToHome(t)) {
                    this.setLoginStatus("Failed to write token.");
                    this.btnLogin.setEnabled(true);
                    return;
                }
                this.currentUser = user;
                this.token = t;
                SwingUtilities.invokeLater(() -> {
                    this.helloUser.setText("Hello, " + this.currentUser + "!");
                    this.cards.show(this.root, "install");
                });
                this.setLoginStatus("Logged in.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setLoginStatus("Login failed: " + (ex.getMessage() == null ? "Error" : ex.getMessage()));
            }
            finally {
                SwingUtilities.invokeLater(() -> this.btnLogin.setEnabled(true));
            }
        }).start();
    }

    private void doSignup() {
        this.setSignupStatus("Creating account\u2026");
        this.btnSignup.setEnabled(false);
        new Thread(() -> {
            try {
                String user = this.suUser.getText().trim();
                String pass = new String(this.suPass.getPassword());
                String regKey = this.suRegKey.getText().trim();
                String hwid = VerseInstallerApp.computeHwid();
                if (user.isEmpty() || pass.isEmpty() || regKey.isEmpty()) {
                    this.setSignupStatus("Fill all fields.");
                    this.btnSignup.setEnabled(true);
                    return;
                }
                HttpClient client = HttpClient.newHttpClient();
                String payload = "{\"user\":\"" + VerseInstallerApp.json(user) + "\",\"pass\":\"" + VerseInstallerApp.json(pass) + "\",\"regKey\":\"" + VerseInstallerApp.json(regKey) + "\",\"hwid\":\"" + VerseInstallerApp.json(hwid) + "\"}";
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create("http://206.45.90.56:5544/v1/signup")).header("Content-Type", "application/json; charset=UTF-8").POST(HttpRequest.BodyPublishers.ofString(payload, StandardCharsets.UTF_8)).build();
                HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
                if (resp.statusCode() != 200) {
                    this.setSignupStatus("Server error: " + resp.statusCode());
                    this.btnSignup.setEnabled(true);
                    return;
                }
                if (!resp.body().contains("\"ok\":true")) {
                    String err = VerseInstallerApp.extractJsonString(resp.body(), "error");
                    this.setSignupStatus(err == null ? "Sign up failed." : err);
                    this.btnSignup.setEnabled(true);
                    return;
                }
                String t = VerseInstallerApp.extractJsonString(resp.body(), "token");
                if (t == null || t.length() != 16) {
                    this.setSignupStatus("Bad token from server.");
                    this.btnSignup.setEnabled(true);
                    return;
                }
                if (!this.writeTokenToHome(t)) {
                    this.setSignupStatus("Failed to write token.");
                    this.btnSignup.setEnabled(true);
                    return;
                }
                this.currentUser = user;
                this.token = t;
                SwingUtilities.invokeLater(() -> {
                    this.helloUser.setText("Hello, " + this.currentUser + "!");
                    this.cards.show(this.root, "install");
                });
                this.setSignupStatus("Account created.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setSignupStatus("Signup failed: " + (ex.getMessage() == null ? "Error" : ex.getMessage()));
            }
            finally {
                SwingUtilities.invokeLater(() -> this.btnSignup.setEnabled(true));
            }
        }).start();
    }

    private void doInstall() {
        this.setInstallStatus("Installing loader\u2026");
        this.installBtn.setEnabled(false);
        new Thread(() -> {
            try {
                String path = this.pathField.getText().trim();
                if (path.isEmpty()) {
                    this.setInstallStatus("Select an install path.");
                    this.installBtn.setEnabled(true);
                    return;
                }
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    this.setInstallStatus("Failed to create directory:\n" + path);
                    this.installBtn.setEnabled(true);
                    return;
                }
                if (this.token == null || this.token.length() != 16) {
                    this.setInstallStatus("Not logged in.");
                    this.installBtn.setEnabled(true);
                    return;
                }
                String hwid = VerseInstallerApp.computeHwid();
                byte[] loaderBytes = this.fetchLatestLoader(this.token, hwid);
                if (loaderBytes == null || loaderBytes.length == 0) {
                    this.setInstallStatus("Failed to download loader.");
                    this.installBtn.setEnabled(true);
                    return;
                }
                File out = new File(dir, "verse-loader.jar");
                try (FileOutputStream fos = new FileOutputStream(out);){
                    fos.write(loaderBytes);
                }
                this.setInstallStatus("Loader installed to:\n" + out.getAbsolutePath());
                JOptionPane.showMessageDialog(this, "Loader installed to:\n" + out.getAbsolutePath(), "Install Complete", 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setInstallStatus("Install failed: " + (ex.getMessage() == null ? "Error" : ex.getMessage()));
            }
            finally {
                SwingUtilities.invokeLater(() -> this.installBtn.setEnabled(true));
            }
        }).start();
    }

    private byte[] fetchLatestLoader(String token, String hwid) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            String payload = "{\"token\":\"" + VerseInstallerApp.json(token) + "\",\"hwid\":\"" + VerseInstallerApp.json(hwid) + "\"}";
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create("http://206.45.90.56:5544/v1/loader/latest")).header("Content-Type", "application/json; charset=UTF-8").POST(HttpRequest.BodyPublishers.ofString(payload, StandardCharsets.UTF_8)).build();
            HttpResponse<byte[]> resp = client.send(req, HttpResponse.BodyHandlers.ofByteArray());
            if (resp.statusCode() != 200) {
                String errTxt = "HTTP " + resp.statusCode();
                try {
                    String body = new String(resp.body(), StandardCharsets.UTF_8);
                    if (body.startsWith("{")) {
                        errTxt = errTxt + " " + body;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setInstallStatus("Server error: " + errTxt);
                return null;
            }
            return resp.body();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setInstallStatus("Loader fetch failed: " + e.getMessage());
            return null;
        }
    }

    private boolean writeTokenToHome(String t) {
        try {
            File homeDir = new File(System.getProperty("user.home"), "Verse");
            if (!homeDir.exists() && !homeDir.mkdirs()) {
                return false;
            }
            File tokenFile = new File(homeDir, "token.txt");
            Files.writeString(tokenFile.toPath(), (CharSequence)t, StandardCharsets.UTF_8, new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String computeHwid() {
        try {
            String raw = (System.getenv("PROCESS_IDENTIFIER") == null ? "" : System.getenv("PROCESS_IDENTIFIER")) + (System.getenv("PROCESSOR_LEVEL") == null ? "" : System.getenv("PROCESSOR_LEVEL")) + (System.getenv("PROCESSOR_REVISION") == null ? "" : System.getenv("PROCESSOR_REVISION")) + (System.getenv("PROCESSOR_ARCHITECTURE") == null ? "" : System.getenv("PROCESSOR_ARCHITECTURE")) + (System.getenv("PROCESSOR_ARCHITEW6432") == null ? "" : System.getenv("PROCESSOR_ARCHITEW6432")) + (System.getenv("NUMBER_OF_PROCESSORS") == null ? "" : System.getenv("NUMBER_OF_PROCESSORS")) + (System.getenv("COMPUTERNAME") == null ? "" : System.getenv("COMPUTERNAME"));
            String aes = "AES";
            String key = "LootTechHWIDKey!";
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
            cipher.init(1, skey);
            byte[] result = cipher.doFinal(raw.getBytes(StandardCharsets.UTF_8));
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(result);
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02X", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "UNKNOWNHWID000000000000000000000000";
        }
    }

    private void setLoginStatus(String s) {
        SwingUtilities.invokeLater(() -> this.loginStatus.setText(s));
    }

    private void setSignupStatus(String s) {
        SwingUtilities.invokeLater(() -> this.signupStatus.setText(s));
    }

    private void setInstallStatus(String s) {
        SwingUtilities.invokeLater(() -> this.installStatus.setText(s));
    }

    private static String json(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String extractJsonString(String json, String key) {
        String pat = "\"" + key + "\":\"";
        int i = json.indexOf(pat);
        if (i < 0) {
            return null;
        }
        int start = i + pat.length();
        int end = json.indexOf("\"", start);
        if (end < 0) {
            return null;
        }
        return json.substring(start, end);
    }

    private void choosePath() {
        JFileChooser ch = new JFileChooser();
        ch.setDialogTitle("Select Install Directory");
        ch.setFileSelectionMode(1);
        if (ch.showOpenDialog(this) == 0) {
            this.pathField.setText(ch.getSelectedFile().getAbsolutePath());
        }
    }
}

